﻿/*
** Copyright (C) 2011 - 2015 PROMESS
** Gesellschaft für Montage und Prüfsysteme mbH
** ALL RIGHTS RESERVED
** Developers:
** Andreas Groch
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace AstasDllCSharpTest.Astas
{
    public enum ErrorCode
    {
        NoErr = 0,
        Err = 1,
        ErrDeviceNotOpen = 10,
        ErrFuncNotImpl = 20,
        ErrDeviceNotExist = 254,
        ErrDllNotInit = 255
    }

    [StructLayoutAttribute(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
    public struct DeviceInfoItem
    {
        /// DWORD->unsigned int
        internal uint idx;

        /// int
        internal int open;

        /// char[256]
        [MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst = 256)]
        internal string vid_pid;

        /// char[256]
        [MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst = 256)]
        internal string dev_info;

        /// char[256]
        [MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst = 256)]
        internal string sn_info;

        /// int
        internal int hw_info;

        /// int
        internal int hw_var;

        /// int
        internal int fw_vers;

        /// int
        internal int chn;
    }

    [StructLayoutAttribute(LayoutKind.Sequential, Pack = 1, CharSet = CharSet.Ansi)]
    public struct DeviceInfo
    {
        internal DeviceInfoItem item0;
        internal DeviceInfoItem item1;
        internal DeviceInfoItem item2;
        internal DeviceInfoItem item3;
        internal DeviceInfoItem item4;
        internal DeviceInfoItem item5;
        internal DeviceInfoItem item6;
        internal DeviceInfoItem item7;
        internal DeviceInfoItem item8;
        internal DeviceInfoItem item9;
        internal DeviceInfoItem item10;
        internal DeviceInfoItem item11;
        internal DeviceInfoItem item12;
        internal DeviceInfoItem item13;
        internal DeviceInfoItem item14;
        internal DeviceInfoItem item15;
        //internal DeviceInfoItem[] items;
    }

    [SuppressMessage("Microsoft.Design", "CA1028:EnumStorageShouldBeInt32")]
    public enum MeasuringUnit : int
    {
        // Potentially use clear names for the units like Newton for N
        User = 0,
        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "N")]
        N,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "k")]
        kN,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "g")]
        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "g")]
        g,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "kg")]
        kg,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "t")]
        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "t")]
        t,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "lbf")]
        lbf,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "oz")]
        oz,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "m")]
        mVPerV,
        M300,
        M600,
        [SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "to")]
        to
    }

    [SuppressMessage("Microsoft.Design", "CA1028:EnumStorageShouldBeInt32"), Flags()]
    public enum Status : int
    {
        Reserviert = 0x01,  // Reserviert
        Null = 0x02,        // Null-Anzeige (Netto Wert)
        Tara = 0x04,        // Tara (Gerät wurde tariert)
        Over = 0x08,        // Überlast
        Under = 0x10,       // Unterlast
        ChgUnit = 0x20,     // Änd. Maßeinheit
        ChgRange = 0x40,    // Änd. Messbereich
        AdcError = 0x80     // ADC-Error
    }

    [StructLayoutAttribute(LayoutKind.Sequential, Pack = 1)]
    public struct DeviceData
    {
        internal float brutto;      // Brutto
        internal float netto;       // Netto
        internal float tara;        // Tara
        internal float min;         // Min (bezogen auf die aktuelle Anzeige)
        internal float max;         // Max (bezogen auf die aktuelle Anzeige)
        internal MeasuringUnit me;  // Maßeinheit (0...x)
        internal int dec;           // Anzahl Nachkommastellen
        internal Status status;     // Status
    }

    public struct DllVersion
    {
        public DllVersion(int version)
        {
            major = (byte)((version & 0xFF000000) >> 24);
            minor = (byte)((version & 0x00FF0000) >> 16);
            revision = (byte)((version & 0x0000FF00) >> 8);
            build = (byte)(version & 0x000000FF);
        }

        internal byte major;
        internal byte minor;
        internal byte revision;
        internal byte build;
    }
}
